package gihyo.lucene.ch1;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;

public class HelloLucene {

    private static final String FIELD_CONTENT = "content";
    private static final Directory directory = new RAMDirectory();
    private static final Analyzer analyzer = new JapaneseAnalyzer();
    private static final QueryParser qp = new QueryParser( FIELD_CONTENT, analyzer );

    private static final String[] contents = {
	"JcI̓TUG̒", "TUG̓J̎o", "J̓JcI̖",
	"JcI͒j", "TUG͒", "J͎",
	"}XI̓TUG̕v", "g͏M̕v", "^̃pp̓}XI",
	"TUGƃ}XI͕vw", "g̓^̑c", "M̓JcI̕",
	"}XI̓JcI̋`Z", "JcI̓^̏f", "M̓J̕"
    };

    public static void main( String[] args ) throws IOException, ParseException {
	makeIndex();
	BufferedReader br = new BufferedReader( new InputStreamReader( System.in ) );
	String q = null;
	while( q == null || !q.equals( "q" ) ){
	    System.out.print( "\niqŏIj> " );
	    System.out.flush();
	    q = br.readLine();
	    if( !q.equals( "q" ) )
		searchIndex( q );
	}
	br.close();
	if( directory != null )
	    directory.close();
    }

    private static void makeIndex() throws IOException {
	IndexWriter writer = new IndexWriter( directory, analyzer, true );
	for( int i = 0; i < contents.length; i++ ){
	    Document doc = new Document();
	    doc.add( new Field( FIELD_CONTENT, contents[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    writer.addDocument( doc );
	}
	writer.close();
    }

    private static void searchIndex( final String q ) throws IOException, ParseException {
	IndexSearcher searcher = new IndexSearcher( directory );
	Query query = qp.parse( q );
	Hits hits = searcher.search( query );
	int length = hits.length();
	System.out.println( Integer.toString( length ) + "qbg܂B" );
	for( int i = 0; i < length; i++ ){
	    Document doc = hits.doc( i );
	    System.out.println( "\t" + doc.get( FIELD_CONTENT ) );
	}
	searcher.close();
    }
}
