package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Token;

public abstract class AbstractDisplayTokenStream {

    public static final String[] contents = {
	"Kl͊̈ꕔłB",
	"JLNPRABCwxy123STU",
	"siR|P|P@iq}ڍrijZp]_",
	"ucŋAJłAă}}łv",
	"URL: http://www.gihyo.co.jp/, e-mail: info@gihyo.co.jp",
	"Non-authoritative answer:\nName:\t[www.gihyo.co.jp]\nAddress:\t[219.101.198.4]",
	"(߁)!!",
	"Lucene is a full-featured text search engine library written in Java."
    };

    public abstract Analyzer getAnalyzer();

    public void displayTokenStream() throws IOException {
	for( int i = 0; i < contents.length; i++ ){
	    System.out.println( "\n" + contents[i] );
	    System.out.println( "========================================================" );
	    StringReader reader = new StringReader( contents[i] );
	    TokenStream stream = getAnalyzer().tokenStream( "", reader );
	    displayTokens( stream );
	    stream.close();
	}
    }

    protected void displayTokens( final TokenStream stream ) throws IOException {
	System.out.println( "|eLXg\t|ʒu\t|Jn\t|I\t|" );
	System.out.println( "+---------------+---------------+-------+-------+-------" );
	Token token = null;
	while( ( token = stream.next() ) != null ){
	    String text = token.termText();
	    String posinc = Integer.toString( token.getPositionIncrement() );
	    String start = Integer.toString( token.startOffset() );
	    String end = Integer.toString( token.endOffset() );
	    String type = token.type();
	    System.out.println( " " + text + "\t\t " +
				posinc + "\t\t " +
				start + "\t " +
				end + "\t " +
				type );
	}
    }
}
