package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.StringReader;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.Token;

public abstract class AbstractTestFilter {

    protected Analyzer analyzer = new WhitespaceAnalyzer();

    protected TokenStream getTokenStream( final String source ){
	return analyzer.tokenStream( "", new StringReader( source ) );
    }

    protected void filter( final String source, final TokenFilter filter ) throws IOException {
	System.out.print( source + "\t=>\t" );
	Token t;
	while( ( t = filter.next() ) != null )
	    System.out.print( "[" + t.termText() + "] " );
	filter.close();
	System.out.print( "\n" );
    }
}
