package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.analysis.ja.DigitFilter;

public class TestDigitFilter extends AbstractTestFilter {

    public static void main( String[] args ) throws IOException {

	final String SUJI1 = "123 4 5 6";
	final String SUJI2 = "12 34 5 6 7 890";

	AbstractTestFilter atf = new TestDigitFilter();
	atf.filter( SUJI1, new DigitFilter( atf.getTokenStream( SUJI1 ) ) );
	atf.filter( SUJI2, new DigitFilter( atf.getTokenStream( SUJI2 ) ) );
    }
}

