package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.analysis.ja.KatakanaStemFilter;

public class TestKatakanaStemFilter extends AbstractTestFilter {

    public static void main( String[] args ) throws IOException {

	final String STR1 = "Rs[^[";
	final String STR2 = "RXgN^[";
	final String STR3 = "[U[";
	final String STR4 = "L[";
	final String STR5 = "}i[";

	AbstractTestFilter atf = new TestKatakanaStemFilter();
	atf.filter( STR1, new KatakanaStemFilter( atf.getTokenStream( STR1 ) ) );
	atf.filter( STR2, new KatakanaStemFilter( atf.getTokenStream( STR2 ) ) );
	atf.filter( STR3, new KatakanaStemFilter( atf.getTokenStream( STR3 ) ) );
	atf.filter( STR4, new KatakanaStemFilter( atf.getTokenStream( STR4 ) ) );
	atf.filter( STR5, new KatakanaStemFilter( atf.getTokenStream( STR5 ) ) );
    }
}

