package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.analysis.LowerCaseFilter;

public class TestLowerCaseFilter extends AbstractTestFilter {

    public static void main( String[] args ) throws IOException {

	final String STR1 = "ABC XYZ";
	final String STR2 = "Lucene was originally written by Doug Cutting.";

	AbstractTestFilter atf = new TestLowerCaseFilter();
	atf.filter( STR1, new LowerCaseFilter( atf.getTokenStream( STR1 ) ) );
	atf.filter( STR2, new LowerCaseFilter( atf.getTokenStream( STR2 ) ) );
    }
}

