package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;
import org.apache.lucene.analysis.ja.NormalizeReader;

public class TestNormalizeReader {

    public static void main( String[] args ) throws IOException {

	final String KATAKANA1 = "";
	final String KATAKANA2 = "۸";
	final String EISUJI = "`abPQR";
	final String KIGO = "HIhfij";

	convert( KATAKANA1 );
	convert( KATAKANA2 );
	convert( EISUJI );
	convert( KIGO );
    }

    private static void convert( final String source ) throws IOException {
	System.out.print( source + "\t=>\t" );
	Reader reader = new NormalizeReader( new StringReader( source ) );
	int c;
	while( ( c = reader.read() ) != 0xFFFF )
	    System.out.print( (char)c );
	reader.close();
	System.out.print( "\n" );
    }
}

