package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;

public class TestPerFieldAnalyzerWrapper {

    static Analyzer analyzer;
    static Directory directory = new RAMDirectory();

    static final String[] authors = { "{݂䂫", "\" };
    static final String[] authorsKana = { "~x~L", "qKVmPCS" };
    static final String[] books = { "͕", "s" };
    static final String[] booksKana = { "zEn", "rNRE" };
    static final String F_AUTHOR = "Ɩ";
    static final String F_AUTHOR_KANA = "Ɩ";
    static final String F_BOOK = "i";
    static final String F_BOOK_KANA = "i";

    public static void main( String[] args ) throws IOException, ParseException {

	makeIndex();
	List queries = getQueries();
	for( Iterator i = queries.iterator(); i.hasNext(); ){
	    Query query = (Query)i.next();
	    searchIndex( query );
	}
	directory.close();
    }

    static Analyzer getAnalyzer(){
	if( analyzer == null ){
	    PerFieldAnalyzerWrapper wrapper = new PerFieldAnalyzerWrapper( new JapaneseAnalyzer() );
	    wrapper.addAnalyzer( F_AUTHOR_KANA, new CJKAnalyzer() );
	    wrapper.addAnalyzer( F_BOOK_KANA, new CJKAnalyzer() );
	    analyzer = wrapper;
	}
	return analyzer;
    }

    static void makeIndex() throws IOException {
	IndexWriter writer = new IndexWriter( directory, getAnalyzer(), true );
	for( int i = 0; i < authors.length; i++ ){
	    Document document = new Document();
	    document.add( new Field( F_AUTHOR, authors[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    document.add( new Field( F_AUTHOR_KANA, authorsKana[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    document.add( new Field( F_BOOK, books[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    document.add( new Field( F_BOOK_KANA, booksKana[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    writer.addDocument( document );
	}
	writer.close();
    }

    static List getQueries() throws ParseException {
	List queries = new ArrayList();
	QueryParser qp = new QueryParser( F_AUTHOR, getAnalyzer() );
	queries.add( qp.parse( "{݂䂫" ) );
	qp = new QueryParser( F_AUTHOR_KANA, getAnalyzer() );
	queries.add( qp.parse( "qKVm" ) );
	queries.add( qp.parse( "qKVm PCS" ) );
	queries.add( qp.parse( "qKVmPCS" ) );
	return queries;
    }

    static void searchIndex( final Query query ) throws IOException {
	System.out.println( "\nquery = " + query.toString() );
	System.out.println( "=======================================" );
	IndexSearcher searcher = new IndexSearcher( directory );
	Hits hits = searcher.search( query );
	displayHits( hits );
	searcher.close();
    }

    static void displayHits( final Hits hits ) throws IOException {
	if( hits.length() == 0 ){
	    System.out.println( "** qbg܂łB **" );
	    return;
	}
	for( int i = 0; i < hits.length(); i++ ){
	    Document doc = hits.doc( i );
	    System.out.println( F_AUTHOR + " : " + doc.get( F_AUTHOR ) );
	    System.out.println( F_AUTHOR_KANA + " : " + doc.get( F_AUTHOR_KANA ) );
	    System.out.println( F_BOOK + " : " + doc.get( F_BOOK ) );
	    System.out.println( F_BOOK_KANA + " : " + doc.get( F_BOOK_KANA ) );
	}
    }
}
