package gihyo.lucene.ch2;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopAnalyzer;

public class TestStopFilter extends AbstractTestFilter {

    public static void main( String[] args ) throws IOException {

	final String STR1 = "not guilty";
	final String STR2 = "to be or not to be";

	AbstractTestFilter atf = new TestStopFilter();
	atf.filter( STR1, new StopFilter( atf.getTokenStream( STR1 ), StopAnalyzer.ENGLISH_STOP_WORDS ) );
	atf.filter( STR2, new StopFilter( atf.getTokenStream( STR2 ), StopAnalyzer.ENGLISH_STOP_WORDS ) );
    }
}

