package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.index.Term;

public abstract class AbstractMakeIndex {

    protected static final int LOOP_MAX = 100000;
    protected static final String CONTENT = "content";
    protected static final String[] contents = {
	"̃p\R͎wFŃOC܂B",
	"̃p\R͋ߏ̓[ŏEĂ̂łB",
	"͂܂Ƀ[vRUPOgĂ܂B"
    };
    protected Analyzer analyzer = null;

    public void execute( final String path ) throws IOException {

	long s = System.currentTimeMillis();
	Date start = new Date( s );
	System.out.println( "start: " + start );

	makeIndex( path );

	long e = System.currentTimeMillis();
	Date end = new Date( e );
	long elapse = e - s;
	System.out.println( "end: " + end + "(elapse: " + elapse + "msec)" );

	checkIndex( path );
    }

    protected abstract void makeIndex( final String path ) throws IOException;

    protected synchronized Analyzer getAnalyzer(){
	if( analyzer == null )
	    analyzer = new JapaneseAnalyzer();
	return analyzer;
    }

    protected Document getDocument( final String str ) throws IOException {
	Document doc = new Document();
	doc.add( new Field( CONTENT, str, Field.Store.YES, Field.Index.TOKENIZED ) );
	return doc;
    }

    protected void checkIndex( final String path ) throws IOException {
	IndexSearcher searcher = new IndexSearcher( path );
	checkCount( searcher, "p\R", LOOP_MAX * 2 );
	checkCount( searcher, "[v", LOOP_MAX * 1 );
	searcher.close();
    }

    private void checkCount( final IndexSearcher searcher,
			     final String word, final int count )
	throws IOException {
	Hits hits = searcher.search( new TermQuery( new Term( CONTENT, word ) ) );
	if( hits.length() == count )
	    System.out.println( "*** \"" + word + "\"  " + count + " ݂܂B" );
	else
	    System.out.println( "*** \"" + word + "\"  " + count + " ݂܂łB " + hits.length() + " łB" );
    }
}
