package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.DateFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class AbstractTestIndexReader {

    protected static final String[] contents = {
	"JcI̓TUG̒", "TUG̓J̎o", "J̓JcI̖",
	"JcI͒j", "TUG͒", "J͎",
	"}XI̓TUG̕v", "g͏M̕v", "^̃pp̓}XI",
	"TUGƃ}XI͕vw", "g̓^̑c", "M̓JcI̕",
	"}XI̓JcI̋`Z", "JcI̓^̏f", "M̓J̕"
    };
    protected static final String F_ID = "ԍ";
    protected static final String F_CONTENT = "Rec";
    protected Analyzer analyzer;
    protected Directory directory;
    protected DateFormat formatter = new SimpleDateFormat( "yyyy/MM/dd HH:mm:ss.SSS" );

    protected String[] getContents(){
	return contents;
    }

    protected Analyzer getAnalyzer(){
	if( analyzer == null )
	    analyzer = new JapaneseAnalyzer();
	return analyzer;
    }

    protected Directory getNewDirectory() throws IOException {
	return new RAMDirectory();
    }

    protected Directory getDirectory() throws IOException {
	if( directory == null )
	    directory = getNewDirectory();
	return directory;
    }

    protected void makeIndex() throws IOException {
	makeIndex( true );
    }

    protected void makeIndex( final boolean create ) throws IOException {
	Directory directory = getDirectory();
	IndexWriter writer = new IndexWriter( directory, getAnalyzer(), create );
	for( int i = 0; i < getContents().length; i++ ){
	    Document doc = new Document();
	    doc.add( new Field( F_ID, Integer.toString( i + 1 ), Field.Store.YES, Field.Index.UN_TOKENIZED ) );
	    doc.add( new Field( F_CONTENT, getContents()[i], Field.Store.YES, Field.Index.TOKENIZED ) );
	    writer.addDocument( doc );
	}
	writer.close();
    }

    protected IndexReader getIndexReader() throws IOException {
	return IndexReader.open( getDirectory() );
    }

    protected int getDocumentId( final Document doc ){
	return Integer.parseInt( doc.get( F_ID ) );
    }

    protected String getDocumentContent( final Document doc ){
	return doc.get( F_CONTENT );
    }

    protected String dateFormat( final long time ){
	return formatter.format( new Date( time ) );
    }
}
