package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class AbstractThreadLauncher {

    static final String ID = "ID";
    protected static final String DEFAULT_SLEEP_UNIT = "1000";
    protected static final int ID_MIN = 1;
    protected static final int ID_MAX = 10000;
    protected static final String PROP_SLEEP_UNIT = "sleep.unit";

    protected String path;
    protected Analyzer analyzer = new WhitespaceAnalyzer();
    protected IndexWriter writer;
    protected IndexReader reader;
    protected IndexSearcher searcher;
    protected int writerCount;
    protected int readerCount;
    protected int searcherCount;

    protected AbstractThreadLauncher( String path ){
	this.path = path;
    }

    protected long sleepUnit(){
	String sleepUnit = System.getProperty( PROP_SLEEP_UNIT, DEFAULT_SLEEP_UNIT );
	return Long.parseLong( sleepUnit );
    }

    protected void sleep( final String name, final int sleep ){
	System.out.println( name + " : X[v܂EEE" );
	try{
	    Thread.sleep( sleep * sleepUnit() );
	}
	catch( InterruptedException ignore ){}
	System.out.println( name + " : X[vI܂" );
    }

    protected void makeIndex() throws IOException {
	if( IndexReader.indexExists( path ) )
	    return;
	System.out.println( "CfbNX܂B쐬܂BpX=" + path );
	System.out.println( "CfbNX̍쐬ɂ͐܂B" );
	IndexWriter iw = new IndexWriter( path, analyzer, true );
	for( int i = ID_MIN; i <= ID_MAX; i++ ){
	    Document doc = new Document();
	    String id = Integer.toString( i );
	    doc.add( new Field( ID, id, Field.Store.YES, Field.Index.UN_TOKENIZED ) );
	    iw.addDocument( doc );
	}
	iw.close();
	System.out.println( "CfbNX쐬܂B" );
	checkIndex( "main", ID_MIN, ID_MAX );
    }

    public void checkIndex( final String name, final int id1, final int id2 ) throws IOException {
	IndexSearcher searcher = new IndexSearcher( path );
	Hits hits1 = searcher.search( new TermQuery( new Term( ID, Integer.toString( id1 ) ) ) );
	Hits hits2 = searcher.search( new TermQuery( new Term( ID, Integer.toString( id2 ) ) ) );
	if( ( hits1.length() >= 1 ) && ( hits2.length() >= 1 ) )
	    System.out.println( name + " : CfbNX͐쐬Ă܂B" );
	else{
	    System.out.println( name + " : 쐬ꂽCfbNX͐܂B" );
	    System.out.println( name + " : IndexWriterN[YĂȂꍇ́A\ʂ̓łB" );
	}
	searcher.close();
    }

    public IndexWriter getIndexWriter() throws IOException {
	if( writer == null ){
	    System.out.println( "IndexWriterCX^X쐬܂EEE" );
	    writer = new IndexWriter( path, analyzer, true );
	}
	writerCount++;
	return writer;
    }

    public IndexReader getIndexReader() throws IOException {
	if( reader == null ){
	    System.out.println( "IndexReaderCX^X쐬܂EEE" );
	    reader = IndexReader.open( path );
	}
	readerCount++;
	return reader;
    }

    public IndexSearcher getIndexSearcher() throws IOException {
	if( searcher == null ){
	    System.out.println( "IndexSearcherCX^X쐬܂EEE" );
	    searcher = new IndexSearcher( path );
	}
	searcherCount++;
	return searcher;
    }

    public void closeIndexWriter() throws IOException {
	if( --writerCount == 0 ){
	    System.out.println( "IndexWriterN[Y܂EEE" );
	    writer.close();
	}
    }

    public void closeIndexReader() throws IOException {
	if( --readerCount == 0 ){
	    System.out.println( "IndexReaderN[Y܂EEE" );
	    reader.close();
	}
    }

    public void closeIndexSearcher() throws IOException {
	if( --searcherCount == 0 ){
	    System.out.println( "IndexSearcherN[Y܂EEE" );
	    searcher.close();
	}
    }
}
