package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class AddWriterThread extends Thread {

    static final String ID = "ID";
    private String name;
    private int startId;
    private int endId;
    private String path;
    private IndexWriter writer;
    private AbstractThreadLauncher launcher;

    public AddWriterThread( String name, int startId, int endId, AbstractThreadLauncher launcher ) throws IOException {
	this.name = name;
	this.startId = startId;
	this.endId = endId;
	this.launcher = launcher;
	writer = launcher.getIndexWriter();
    }

    public AddWriterThread( String name, int startId, int endId, String path, boolean create ) throws IOException {
	this.name = name;
	this.startId = startId;
	this.endId = endId;
	this.path = path;
	writer = new IndexWriter( path, new WhitespaceAnalyzer(), create );
    }

    public void run(){
	System.out.println( name + " : Jn܂B" );
	try{
	    for( int i = startId; i <= endId; i++ ){
		Document doc = new Document();
		String id = Integer.toString( i );
		doc.add( new Field( ID, id, Field.Store.YES, Field.Index.UN_TOKENIZED ) );
		writer.addDocument( doc );
	    }
	}
	catch( IOException e ){
	    System.out.println( name + " : G[܂BI܂B" );
	    e.printStackTrace();
	    return;
	}
	finally{
	    try{
		if( launcher != null )
		    launcher.closeIndexWriter();
		else if( writer != null )
		    writer.close();
		if( launcher != null )
		    launcher.checkIndex( name, startId, endId );
		else
		    checkIndex( startId, endId );
	    }
	    catch( IOException e ){}
	}
	System.out.println( name + " : I܂B" );
    }

    protected void checkIndex( int id1, int id2 ) throws IOException {
	IndexSearcher searcher = new IndexSearcher( path );
	Hits hits1 = searcher.search( new TermQuery( new Term( ID, Integer.toString( id1 ) ) ) );
	Hits hits2 = searcher.search( new TermQuery( new Term( ID, Integer.toString( id2 ) ) ) );
	if( ( hits1.length() >= 1 ) && ( hits2.length() >= 1 ) )
	    System.out.println( name + " : CfbNX͐쐬Ă܂B" );
	else
	    System.out.println( name + " : 쐬ꂽCfbNX͐܂B" );
	searcher.close();
    }
}
