package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class MakeIndex extends AbstractTestIndexReader {

    String path;

    private MakeIndex( String path ){
	this.path = path;
    }

    public static void main( String[] args ) throws IOException {
	MakeIndex mi = new MakeIndex( args[0] );
	mi.makeIndex();
	mi.getDirectory().close();
    }

    protected Directory getNewDirectory() throws IOException {
	return FSDirectory.getDirectory( path, true );
    }
}
