package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.collections.buffer.BlockingBuffer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.FSDirectory;

public class MultiThread extends AbstractMakeIndex {

    private Buffer buffer;
    private List threads;

    public static void main( String[] args ) throws IOException {
	MultiThread mt = new MultiThread();
	mt.execute( args[0] );
    }

    MultiThread(){
	buffer = BlockingBuffer.decorate( new UnboundedFifoBuffer() );
	threads = new ArrayList();
	for( int i = 0; i < contents.length; i++ ){
	    String name = "RAMIndexerThread-" + Integer.toString( i );
	    threads.add( new RAMIndexerThread( name, buffer, contents[i] ) );
	}
    }

    protected void makeIndex( final String path ) throws IOException {

	for( Iterator i = threads.iterator(); i.hasNext(); ){
	    Thread rit = (RAMIndexerThread)i.next();
	    rit.start();
	}

	IndexWriter writer = new IndexWriter( path, getAnalyzer(), true );
	int count = 0;
	while( count < threads.size() ){
	    Directory[] directories = { (Directory)buffer.remove() };
	    writer.addIndexes( directories );
	    count++;
	}
	writer.close();
    }

    class RAMIndexerThread extends Thread {

	private String name;
	private Buffer buffer;
	private String content;

	RAMIndexerThread( String name, Buffer buffer, String content ){
	    this.name = name;
	    this.buffer = buffer;
	    this.content = content;
	}

	public void run(){
	    System.out.println( "** " + name + " started." );
	    Directory directory = new RAMDirectory();
	    IndexWriter writer = null;
	    try{
		writer = new IndexWriter( directory, getAnalyzer(), true );
		for( int i = 0; i < LOOP_MAX; i++ )
		    writer.addDocument( getDocument( content ) );
	    }
	    catch( IOException e ){
		e.printStackTrace();
	    }
	    finally{
		try{
		    writer.close();
		}
		catch( IOException e ){}
	    }
	    buffer.add( directory );
	    System.out.println( "** " + name + " exited." );
	}
    }
}
