package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;

public class Test2ReaderThreads extends AbstractThreadLauncher {

    public static void main( String[] args ) throws IOException {
	Test2ReaderThreads t = new Test2ReaderThreads( args[0] );
	t.execute();
    }

    private Test2ReaderThreads( String path ){
	super( path );
    }

    private void execute() throws IOException {
	makeIndex();
	DocReaderThread tr1 = new DocReaderThread( "Reader(1)", 1, 1000, path );
	DocReaderThread tr2 = new DocReaderThread( "Reader(2)", 101, 1100, path );
	tr1.start();
	tr2.start();
    }
}
