package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;

public class Test2WriterThreads extends AbstractThreadLauncher {

    public static void main( String[] args ) throws IOException {
	Test2WriterThreads t = new Test2WriterThreads( args[0] );
	t.execute();
    }

    private Test2WriterThreads( String path ){
	super( path );
    }

    private void execute() throws IOException {
	makeIndex();
	int min = ID_MAX + ID_MIN;
	int max = ID_MAX + ID_MAX / 2;
	AddWriterThread tw1 = new AddWriterThread( "Writer(1)", min, max, path, false );
	tw1.start();
	sleep( "main", 10 );
	try{
	    System.out.println( "Writer(2)XbhN܂EEE" );
	    min = ID_MAX + ID_MAX / 2 + ID_MIN;
	    max = ID_MAX + ID_MAX;
	    AddWriterThread tw2 = new AddWriterThread( "Writer(2)", min, max, path, false );
	    tw2.start();
	}
	catch( IOException e ){
	    System.out.println( "O܂B\ʂ̓łB" + e.toString() );
	    System.out.println( "Writer(1)Xbh܂ŁA΂炭҂B" );
	}
    }
}
