package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class TestAddIndexes {

    static final String CONTENT1 = "CfbNXiPj";
    static final String CONTENT2 = "CfbNXiQj";
    static final String CONTENT3 = "CfbNXiRj";
    static final String FIELD = "content";
    static final Analyzer analyzer = new JapaneseAnalyzer();

    public static void main( String[] args ) throws IOException {
	Directory dir1 = makeIndex( CONTENT1 );
	printAllDocs( "CfbNXiPj̓e", dir1 );
	Directory dir2 = makeIndex( CONTENT2 );
	printAllDocs( "CfbNXiQj̓e", dir2 );
	Directory dir3 = makeIndex( CONTENT3 );
	printAllDocs( "CfbNXiRj̓e", dir3 );
	Directory directory = merge( new Directory[]{ dir1, dir2, dir3 } );
	printAllDocs( "}[W̃CfbNX̓e", directory );
    }

    static Directory makeIndex( final String content ) throws IOException {
	Directory directory = new RAMDirectory();
	IndexWriter writer = new IndexWriter( directory, analyzer, true );
	Document doc = new Document();
	doc.add( new Field( FIELD, content, Field.Store.YES, Field.Index.TOKENIZED ) );
	writer.addDocument( doc );
	writer.close();
	return directory;
    }

    static void printAllDocs( final String title,
			      final Directory directory ) throws IOException {
	System.out.println( "\n" + title );
	IndexReader reader = IndexReader.open( directory );
	for( int i = 0; i < reader.maxDoc(); i++ ){
	    Document doc = reader.document( i );
	    System.out.println( Integer.toString( i ) + " : " + doc.get( FIELD ) );
	}
	reader.close();
    }

    static Directory merge( final Directory[] dirs ) throws IOException {
	Directory directory = new RAMDirectory();
	IndexWriter writer = new IndexWriter( directory, analyzer, true );
	writer.addIndexes( dirs );
	writer.close();
	return directory;
    }
}
