package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class TestCreateOrUpdate {

    static final String content = "OɐH킹^͂˂I";
    static final String FIELD = "content";
    static Directory directory;
    static final Analyzer analyzer = new JapaneseAnalyzer();

    public static void main( String[] args ) throws IOException {
	String path = args[0];
	boolean create = getCreateFlag( path );
	makeIndex( path, create );
	printAllDocs();
	if( directory != null )
	    directory.close();
    }

    static boolean getCreateFlag( final String path ){
	boolean exists = IndexReader.indexExists( path );
	if( exists ){
	    System.out.println( "CfbNX݂͑܂BDocumentǉ܂B" );
	    return false;
	}
	System.out.println( "CfbNX݂͑ȂߐVK쐬܂B" );
	return true;
    }

    static void makeIndex( final String path, final boolean create ) throws IOException {
	directory = FSDirectory.getDirectory( path, create );
	IndexWriter writer = new IndexWriter( directory, analyzer, create );
	Document doc = new Document();
	doc.add( new Field( FIELD, content, Field.Store.YES, Field.Index.TOKENIZED ) );
	writer.addDocument( doc );
	writer.close();
    }

    static void printAllDocs() throws IOException {
	IndexReader reader = IndexReader.open( directory );
	for( int i = 0; i < reader.maxDoc(); i++ ){
	    Document doc = reader.document( i );
	    System.out.println( Integer.toString( i ) + " : " + doc.get( FIELD ) );
	}
	reader.close();
    }
}
