package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.Date;
import java.text.ParseException;
import org.apache.lucene.document.DateTools;

public class TestDateTools {

    public static void main( String[] args ) throws ParseException {

	Date date = new Date();
	execDateToString( date );
	execTimeToString( date.getTime() );

	String str1 = "20060301101112000";
	execStringToDate( str1 );
	execStringToTime( str1 );

	String str2 = "20060301";
	execStringToDate( str2 );
	execStringToTime( str2 );

	execRoundDate( date );
	execRoundTime( date.getTime() );
    }

    static void execDateToString( final Date date ){
	System.out.println( "\"" + date + "\" 낢Resolutionŕϊ" );
	execDateToString( date, DateTools.Resolution.YEAR );
	execDateToString( date, DateTools.Resolution.MONTH );
	execDateToString( date, DateTools.Resolution.DAY );
	execDateToString( date, DateTools.Resolution.HOUR );
	execDateToString( date, DateTools.Resolution.MINUTE );
	execDateToString( date, DateTools.Resolution.SECOND );
	execDateToString( date, DateTools.Resolution.MILLISECOND );
    }

    static void execDateToString( final Date date, final DateTools.Resolution reso ){
	System.out.println( reso + "\t=>\t" +
			    DateTools.dateToString( date, reso ) );
    }

    static void execTimeToString( final long time ){
	System.out.println( "\n\"" + time + "\" 낢Resolutionŕϊ" );
	execTimeToString( time, DateTools.Resolution.YEAR );
	execTimeToString( time, DateTools.Resolution.MONTH );
	execTimeToString( time, DateTools.Resolution.DAY );
	execTimeToString( time, DateTools.Resolution.HOUR );
	execTimeToString( time, DateTools.Resolution.MINUTE );
	execTimeToString( time, DateTools.Resolution.SECOND );
	execTimeToString( time, DateTools.Resolution.MILLISECOND );
    }

    static void execTimeToString( final long time, final DateTools.Resolution reso ){
	System.out.println( reso + "\t=>\t" +
			    DateTools.timeToString( time, reso ) );
    }

    static void execStringToDate( final String date ) throws ParseException {
	System.out.println( "\n" + date + "\t=>\t" + DateTools.stringToDate( date ) );
    }

    static void execStringToTime( final String time ) throws ParseException {
	long l = DateTools.stringToTime( time );
	System.out.println( "\n" + time + "\t=>\t" + l + "\t=>\t" + new Date( l ) );
    }

    static void execRoundDate( final Date date ){
	System.out.println( "\n\"" + date + "\" 낢ResolutionŊۂ߂" );
	execRoundDate( date, DateTools.Resolution.YEAR );
	execRoundDate( date, DateTools.Resolution.MONTH );
	execRoundDate( date, DateTools.Resolution.DAY );
	execRoundDate( date, DateTools.Resolution.HOUR );
	execRoundDate( date, DateTools.Resolution.MINUTE );
	execRoundDate( date, DateTools.Resolution.SECOND );
	execRoundDate( date, DateTools.Resolution.MILLISECOND );
    }

    static void execRoundDate( final Date date, final DateTools.Resolution reso ){
	System.out.println( reso + "\t=>\t" +
			    DateTools.round( date, reso ) );
    }

    static void execRoundTime( final long time ){
	System.out.println( "\n\"" + time + "\" 낢ResolutionŊۂ߂" );
	execRoundTime( time, DateTools.Resolution.YEAR );
	execRoundTime( time, DateTools.Resolution.MONTH );
	execRoundTime( time, DateTools.Resolution.DAY );
	execRoundTime( time, DateTools.Resolution.HOUR );
	execRoundTime( time, DateTools.Resolution.MINUTE );
	execRoundTime( time, DateTools.Resolution.SECOND );
	execRoundTime( time, DateTools.Resolution.MILLISECOND );
    }

    static void execRoundTime( final long time, final DateTools.Resolution reso ){
	long l = DateTools.round( time, reso );
	System.out.println( reso + "\t=>\t" + l + "\t=>\t" + new Date( l ) );
    }
}
