package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.document.Document;

public class TestDelete extends AbstractTestIndexReader {

    public static void main( String[] args ) throws IOException {
	TestDelete td = new TestDelete();
	td.makeIndex();
	IndexReader reader = td.getIndexReader();

	System.out.print( "" );
	td.printNumberInfo( reader );
	td.printAllDocs( reader );

	System.out.print( "\n\"JcI\"܂ރhLg폜Ă܂EEE" );
	td.delete( reader, "JcI" );
	td.printNumberInfo( reader );
	td.printAllDocs( reader );

	System.out.println( "\nundeleteAll()s܂EEE" );
	reader.undeleteAll();
	td.printNumberInfo( reader );
	td.printAllDocs( reader );

	System.out.print( "\n\"J\"܂ރhLg폜Ă܂EEE" );
	td.delete( reader, "J" );
	td.printNumberInfo( reader );
	td.printAllDocs( reader );

	System.out.println( "\nIndexReaderăI[v܂EEE" );
	reader.close();
	reader = td.getIndexReader();
	td.printNumberInfo( reader );
	td.printAllDocs( reader );

	System.out.println( "\noptimize()AIndexReaderăI[v܂EEE" );
	reader.close();
	td.optimize();
	reader = td.getIndexReader();
	td.printNumberInfo( reader );
	td.printAllDocs( reader );

	reader.close();
    }

    void printNumberInfo( final IndexReader reader ){
	int maxDoc = reader.maxDoc();
	int numDocs = reader.numDocs();
	System.out.println( "maxDoc = " + Integer.toString( maxDoc ) +
			    ", numDocs = " + Integer.toString( numDocs ) );
    }

    void printAllDocs( final IndexReader reader ) throws IOException {
	int maxDoc = reader.maxDoc();
	for( int i = 0; i < maxDoc; i++ ){
	    System.out.print( Integer.toString( i ) + " : " );
	    if( reader.isDeleted( i ) )
		System.out.println( "*** 폜Ă܂ ***" );
	    else{
		Document doc = reader.document( i );
		System.out.println( getDocumentContent( doc ) );
	    }
	}
    }

    void delete( final IndexReader reader, final String str ) throws IOException {
	int n = reader.deleteDocuments( new Term( F_CONTENT, str ) );
	System.out.println( "Y " + Integer.toString( n ) + " " );
    }

    void optimize() throws IOException {
	IndexWriter writer = new IndexWriter( getDirectory(), getAnalyzer(), false );
	writer.optimize();
	writer.close();
    }
}
