package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;

public class TestDocFreq extends AbstractTestIndexReader {

    public static void main( String[] args ) throws IOException {
	TestDocFreq tdf = new TestDocFreq();
	tdf.makeIndex();
	IndexReader reader = tdf.getIndexReader();
	tdf.printDocFreq( reader, "g" );
	tdf.printDocFreq( reader, "M" );
	tdf.printDocFreq( reader, "}XI" );
	tdf.printDocFreq( reader, "TUG" );
	tdf.printDocFreq( reader, "JcI" );
	tdf.printDocFreq( reader, "J" );
	tdf.printDocFreq( reader, "^" );
	reader.close();
    }

    void printDocFreq( final IndexReader reader, final String str ) throws IOException {
	Term term = new Term( F_CONTENT, str );
	int freq = reader.docFreq( term );
	System.out.println( str + " : " + Integer.toString( freq ) );
    }
}
