package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;

public class TestGetFieldNames extends AbstractTestIndexReader {

    public static void main( String[] args ) throws IOException {
	AbstractTestIndexReader atir = new TestGetFieldNames();
	atir.makeIndex();
	IndexReader reader = atir.getIndexReader();
	testIndexed( reader );
	testTermVector( reader );
	reader.close();
    }

    static void testIndexed( final IndexReader reader ){
	System.out.println( "tꂽStB[h̕\" );
	printFields( reader, IndexReader.FieldOption.INDEXED );
    }

    static void testTermVector( final IndexReader reader ){
	System.out.println( "\nTermVectorStB[h̕\" );
	printFields( reader, IndexReader.FieldOption.TERMVECTOR );
    }

    static void printFields( final IndexReader reader, final IndexReader.FieldOption option ){
	Collection col = reader.getFieldNames( option );
	for( Iterator i = col.iterator(); i.hasNext(); ){
	    String field = (String)i.next();
	    System.out.println( "  * " + field );
	}
    }
}
