package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Hits;

public class TestHeteroDocuments {

    private static Directory directory;
    private static Analyzer analyzer;

    static Directory getDirectory(){
	if( directory == null )
	    directory = new RAMDirectory();
	return directory;
    }

    static Analyzer getAnalyzer(){
	if( analyzer == null )
	    analyzer = new JapaneseAnalyzer();
	return analyzer;
    }

    public static void main( String[] args ) throws IOException, ParseException {
	makeIndex1();
	makeIndex2();
	searchIndex1();
	searchIndex2();
    }

    static void makeIndex1() throws IOException {
	IndexWriter writer = new IndexWriter( getDirectory(), getAnalyzer(), true );
	Document doc = new Document();
	doc.add( new Field( "\tgEFAi", "Ajax Pro for Windows", Field.Store.YES, Field.Index.TOKENIZED ) );
	doc.add( new Field( "^", "AJAXP-WIN-001", Field.Store.YES, Field.Index.UN_TOKENIZED ) );
	doc.add( new Field( "ΉvbgtH[", "Windows", Field.Store.YES, Field.Index.TOKENIZED ) );
	doc.add( new Field( "i", "12000", Field.Store.YES, Field.Index.UN_TOKENIZED ) );
	doc.add( new Field( "Tv", "AjaxJ", Field.Store.YES, Field.Index.TOKENIZED ) );
	doc.add( new Field( "ڍא", "WindowspAjaxJ񋟂܂B", Field.Store.YES, Field.Index.TOKENIZED ) );
	writer.addDocument( doc );
	writer.close();
    }

    static void makeIndex2() throws IOException {
	IndexWriter writer = new IndexWriter( getDirectory(), getAnalyzer(), false );
	Document doc = new Document();
	doc.add( new Field( "\tgEFAi", "Ajax Pro Ver 1.0 for Windows", Field.Store.YES, Field.Index.TOKENIZED ) );
	doc.add( new Field( "}jA^Cg", "Ajax Pro for Windows", Field.Store.YES, Field.Index.TOKENIZED ) );
	doc.add( new Field( "}jA{", "Ajax Pro for Windows̖{", Field.Store.YES, Field.Index.TOKENIZED ) );
	writer.addDocument( doc );
	writer.close();
    }

    static void searchIndex1() throws IOException, ParseException {
	IndexSearcher searcher = new IndexSearcher( getDirectory() );
	QueryParser qp = new QueryParser( "\tgEFAi", getAnalyzer() );
	Query query = qp.parse( "Ajax" );
	System.out.println( "query : " + query.toString() );
	Hits hits = searcher.search( query );
	for( int i = 0; i < hits.length(); i++ ){
	    Document doc = hits.doc( i );
	    displayDocument1( doc );
	}
	searcher.close();
    }

    static void displayDocument1( Document doc ){
	System.out.println( "\tgEFAi : " + doc.get( "\tgEFAi" ) );
	System.out.println( "^ : " + doc.get( "^" ) );
	System.out.println( "ΉvbgtH[ : " + doc.get( "ΉvbgtH[" ) );
	System.out.println( "i : " + doc.get( "i" ) );
	System.out.println( "Tv : " + doc.get( "Tv" ) );
	System.out.println( "ڍא : " + doc.get( "ڍא" ) );
    }

    static void searchIndex2() throws IOException, ParseException {
	IndexSearcher searcher = new IndexSearcher( getDirectory() );
	QueryParser qp = new QueryParser( "\tgEFAi", getAnalyzer() );
	Query query = qp.parse( "Ajax" );
	System.out.println( "\nquery : " + query.toString() );
	Hits hits = searcher.search( query );
	for( int i = 0; i < hits.length(); i++ ){
	    Document doc = hits.doc( i );
	    displayDocument2( doc );
	}
	searcher.close();
    }

    static void displayDocument2( Document doc ){
	System.out.println( "\tgEFAi : " + doc.get( "\tgEFAi" ) );
	System.out.println( "}jA^Cg : " + doc.get( "}jA^Cg" ) );
	System.out.println( "}jA{ : " + doc.get( "}jA{" ) );
    }
}
