package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.analysis.SimpleAnalyzer;

public class TestIsLocked {

    static final String LOCKED = "CfbNX̓bNĂ܂B";
    static final String NOT_LOCKED = "CfbNX̓bNĂ܂B";

    public static void main( String[] args ) throws IOException {
	String path = args[0];
	IndexWriter writer = new IndexWriter( path, new SimpleAnalyzer(), true );
	System.out.println( ( IndexReader.isLocked( path ) ? LOCKED : NOT_LOCKED ) );
	writer.close();
	System.out.println( ( IndexReader.isLocked( path ) ? LOCKED : NOT_LOCKED ) );
    }
}
