package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class TestLastModified extends AbstractTestIndexReader {

    String path;

    private TestLastModified( String path ){
	this.path = path;
    }

    public static void main( String[] args ) throws IOException {
	TestLastModified tlm = new TestLastModified( args[0] );
	tlm.makeIndex();
	System.out.println( "ŏIXV : " + tlm.lastModified() );
	System.out.println( "݂̃o[W : " + tlm.currentVersion() );
	tlm.getDirectory().close();
    }

    protected Directory getNewDirectory() throws IOException {
	return FSDirectory.getDirectory( path, true );
    }

    String lastModified() throws IOException {
	return dateFormat( IndexReader.lastModified( path ) );
    }

    String currentVersion() throws IOException {
	return dateFormat( IndexReader.getCurrentVersion( path ) );
    }
}
