package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Collections;
import org.apache.lucene.document.NumberTools;

public class TestNumberTools {

    static final long[] NUMBERS = { 100, 20, 0, -20, -100 };

    public static void main( String[] args ){

	List numbers = getStringList( NUMBERS );
	Collections.sort( numbers );
	execStringToLong( numbers );
    }

    static List getStringList( final long[] numbers ){
	List list = new ArrayList();
	for( int i = 0; i < numbers.length; i++ )
	    list.add( longToString( numbers[i] ) );
	return list;
    }

    static String longToString( final long num ){
	String str = NumberTools.longToString( num );
	System.out.println( num + "\t=>\t" + str );
	return str;
    }

    static void execStringToLong( final List numbers ){
	for( Iterator i = numbers.iterator(); i.hasNext(); ){
	    String num = (String)i.next();
	    System.out.println( num + "\t=>\t" +
				NumberTools.stringToLong( num ) );
	}
    }
}
