package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;

public class TestReaderWriterThreads extends AbstractThreadLauncher {

    public static void main( String[] args ) throws IOException {
	TestReaderWriterThreads t = new TestReaderWriterThreads( args[0] );
	t.execute();
    }

    private TestReaderWriterThreads( String path ){
	super( path );
    }

    private void execute() throws IOException {
	makeIndex();
	int min = ID_MAX + ID_MIN;
	int max = ID_MAX + ID_MAX;
	AddWriterThread tw1 = new AddWriterThread( "Writer(1)", min, max, path, false );
	tw1.start();
	sleep( "main", 10 );
	DocReaderThread tr1 = new DocReaderThread( "Reader(1)", 1, 1000, path );
	DocReaderThread tr2 = new DocReaderThread( "Reader(2)", 101, 1100, path );
	tr1.start();
	tr2.start();
    }
}
