package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.document.Document;

public class TestTermDocs extends AbstractTestIndexReader {

    public static void main( String[] args ) throws IOException {
	TestTermDocs ttd = new TestTermDocs();
	ttd.makeIndex();
	IndexReader reader = ttd.getIndexReader();
	ttd.printDocs( reader, new String[]{ "JcI", "J" } );
	ttd.printDocs( reader, "TUG" );
	reader.close();
    }

    void printDocs( final IndexReader reader, final String[] strs ) throws IOException {
	TermDocs docs = reader.termDocs();
	for( int i = 0; i < strs.length; i++ ){
	    String str = strs[i];
	    System.out.println( "\n\"" + str + "\"܂ނׂẴhLgƊ܂ސ̕\" );
	    printTermDocs( reader, docs, str );
	}
	docs.close();
    }

    void printTermDocs( final IndexReader reader, final TermDocs docs, final String str ) throws IOException {
	docs.seek( new Term( F_CONTENT, str ) );
	while( docs.next() ){
	    Document doc = reader.document( docs.doc() );
	    int freq = docs.freq();
	    System.out.println( "  * " + getDocumentContent( doc ) + " : " +
				Integer.toString( freq ) );
	}
    }

    void printDocs( final IndexReader reader, final String str ) throws IOException {
	System.out.println( "\n\"" + str + "\"܂ނׂẴhLgƊ܂ސ̕\" );
	TermDocs docs = reader.termDocs( new Term( F_CONTENT, str ) );
	printTermDocs( reader, docs );
	docs.close();
    }

    void printTermDocs( final IndexReader reader, final TermDocs docs ) throws IOException {
	while( docs.next() ){
	    Document doc = reader.document( docs.doc() );
	    int freq = docs.freq();
	    System.out.println( "  * " + getDocumentContent( doc ) + " : " +
				Integer.toString( freq ) );
	}
    }
}
