package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.document.Document;

public class TestTermPositions extends AbstractTestIndexReader {

    protected String[] getContents(){
	return new String[]{
	    "JcI̓TUG̒BJ̓JcI̖BJcI͒jB",
	    "TUG̓J̎oBTUG͒BJ͎B"
	};
    }

    public static void main( String[] args ) throws IOException {
	TestTermPositions ttp = new TestTermPositions();
	ttp.makeIndex();
	IndexReader reader = ttp.getIndexReader();
	ttp.printDocs( reader, new String[]{ "JcI", "J" } );
	ttp.printDocs( reader, "TUG" );
	reader.close();
    }

    void printDocs( final IndexReader reader, final String[] strs ) throws IOException {
	TermPositions docs = reader.termPositions();
	for( int i = 0; i < strs.length; i++ ){
	    String str = strs[i];
	    System.out.println( "\n\"" + str + "\"܂ނׂ̂ẴhLgƊ܂ސƈʒu̕\" );
	    printTermPositions( reader, docs, str );
	}
	docs.close();
    }

    void printTermPositions( final IndexReader reader, final TermPositions docs, final String str ) throws IOException {
	docs.seek( new Term( F_CONTENT, str ) );
	while( docs.next() ){
	    Document doc = reader.document( docs.doc() );
	    int freq = docs.freq();
	    System.out.println( "  * " + getDocumentContent( doc ) + " : " +
				Integer.toString( freq ) );
	    System.out.print( "    * ʒu : " );
	    for( int i = 0; i < freq; i++ ){
		if( i > 0 )
		    System.out.print( ", " );
		System.out.print( Integer.toString( docs.nextPosition() ) );
	    }
	    System.out.println( "" );
	}
    }

    void printDocs( final IndexReader reader, final String str ) throws IOException {
	System.out.println( "\n\"" + str + "\"܂ނׂ̂ẴhLgƊ܂ސƈʒu̕\" );
	TermPositions docs = reader.termPositions( new Term( F_CONTENT, str ) );
	printTermPositions( reader, docs );
	docs.close();
    }

    void printTermPositions( final IndexReader reader, final TermPositions docs ) throws IOException {
	while( docs.next() ){
	    Document doc = reader.document( docs.doc() );
	    int freq = docs.freq();
	    System.out.println( "  * " + getDocumentContent( doc ) + " : " +
				Integer.toString( freq ) );
	    System.out.print( "    * ʒu : " );
	    for( int i = 0; i < freq; i++ ){
		if( i > 0 )
		    System.out.print( ", " );
		System.out.print( Integer.toString( docs.nextPosition() ) );
	    }
	    System.out.println( "" );
	}
    }
}
