package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.Term;

public class TestTerms extends AbstractTestIndexReader {

    public static void main( String[] args ) throws IOException {
	AbstractTestIndexReader atir = new TestTerms();
	atir.makeIndex();
	IndexReader reader = atir.getIndexReader();
	printTerms( reader );
	printTerms( reader, "v" );
	printTerms2( reader, "1" );
	reader.close();
    }

    static void printTerms( final IndexReader reader ) throws IOException {
	System.out.println( "CfbNXׂ̂ĂTerm̕\" );
	TermEnum terms = reader.terms();
	printTermEnum( terms );
    }

    static void printTerms( final IndexReader reader, final String str ) throws IOException {
	System.out.println( "\nCfbNX̎wTermTerm̕\" );
	TermEnum terms = reader.terms( new Term( F_CONTENT, str ) );
	printTermEnum( terms );
    }

    static void printTerms2( final IndexReader reader, final String str ) throws IOException {
	System.out.println( "\nCfbNX̎wTermTerm̕\" );
	TermEnum terms = reader.terms( new Term( F_ID, str ) );
	printTermEnum( terms );
    }

    static void printTermEnum( final TermEnum terms ) throws IOException {
	while( terms.next() ){
	    Term term = terms.term();
	    int freq = terms.docFreq();
	    System.out.println( "  * " + term.text() + " : " + Integer.toString( freq ) );
	}
	terms.close();
    }
}
