package gihyo.lucene.ch3;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class TestVersion extends AbstractTestIndexReader {

    String path;

    private TestVersion( String path ){
	this.path = path;
    }

    public static void main( String[] args ) throws IOException {
	TestVersion tv = new TestVersion( args[0] );
	tv.makeIndex();
	System.out.println( "݂̃o[W : " + tv.currentVersion() );
	IndexReader reader = tv.getIndexReader();
	System.out.println( "IndexReader̃o[W : " + tv.version( reader ) );
	System.out.println( "݂̃o[W? : " + tv.isCurrent( reader ) );

	System.out.println( "CfbNXXVĂ܂EEE" );
	tv.makeIndex( false );
	System.out.println( "݂̃o[W : " + tv.currentVersion() );
	System.out.println( "݂̃o[W? : " + tv.isCurrent( reader ) );

	System.out.println( "IndexReaderăI[vĂ܂EEE" );
	reader.close();
	reader = tv.getIndexReader();
	System.out.println( "IndexReader̃o[W : " + tv.version( reader ) );
	System.out.println( "݂̃o[W? : " + tv.isCurrent( reader ) );

	reader.close();
	tv.getDirectory().close();
    }

    protected Directory getNewDirectory() throws IOException {
	return FSDirectory.getDirectory( path, true );
    }

    String isCurrent( final IndexReader reader ) throws IOException {
	return reader.isCurrent() ? "͂" : "";
    }

    String currentVersion() throws IOException {
	return dateFormat( IndexReader.getCurrentVersion( path ) );
    }

    String version( final IndexReader reader ) throws IOException {
	return dateFormat( reader.getVersion() );
    }
}
