package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.document.NumberTools;
import gihyo.lucene.ch3.BookIndexer;

public abstract class AbstractBookSearcher extends AbstractSearcher {

    private String indexDir;
    private Directory directory;

    protected AbstractBookSearcher( String indexDir ){
	this.indexDir = indexDir;
    }

    protected void printDocument( final Document doc ){
	System.out.println( "==========================================" );
	System.out.println( "oŎ = " + doc.get( BookIndexer.F_PUBLISHER ) );
	System.out.println( "JeS = " + doc.get( BookIndexer.F_CATEGORY ) );
	System.out.println( "^Cg = " + doc.get( BookIndexer.F_TITLE ) );
	System.out.println( " = " + doc.get( BookIndexer.F_AUTHOR ) );
	System.out.println( "y[W = " + getLongString( doc.get( BookIndexer.F_PAGES ) ) + "y[W" );
	System.out.println( "ISBN = " + doc.get( BookIndexer.F_ISBN ) );
	System.out.println( "s = " + doc.get( BookIndexer.F_DATE ) );
	System.out.println( "i = " + getLongString( doc.get( BookIndexer.F_PRICE ) ) + "~" );
	System.out.println( "Tv = " + doc.get( BookIndexer.F_SUMMARY ) );
    }

    protected void printSummary( final Document doc ){
	System.out.println( "==========================================" );
	System.out.println( "^Cg = " + doc.get( BookIndexer.F_TITLE ) );
	System.out.println( " = " + doc.get( BookIndexer.F_AUTHOR ) );
    }

    private String getLongString( final String s ){
	return Long.toString( NumberTools.stringToLong( s ) );
    }

    protected Directory getDirectory() throws SearcherException {
	try{
	    if( directory == null )
		directory = FSDirectory.getDirectory( indexDir, false );
	}
	catch( IOException e ){
	    throw new SearcherException( e );
	}
	return directory;
    }
}
