package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import gihyo.lucene.ch3.PostIndexer;

public abstract class AbstractPostSearcher extends AbstractSearcher {

    private String indexDir;
    private Directory directory;

    protected AbstractPostSearcher( String indexDir ){
	this.indexDir = indexDir;
    }

    protected void printDocument( final Document doc ){
	System.out.println( "==========================================" );
	System.out.println( "ԍ = " + doc.get( PostIndexer.F_CODE ) );
	System.out.println( "Ji = " + doc.get( PostIndexer.F_KANA ) );
	System.out.println( " = " + doc.get( PostIndexer.F_NAME ) );
	System.out.println( "Z = " + doc.get( PostIndexer.F_ADDR ) );
	System.out.println( "Rec = " + doc.get( PostIndexer.F_CONTENT ) );
	System.out.println( "ʗX֔ԍ = " + doc.get( PostIndexer.F_INDZIP ) );
	System.out.println( "X֔ԍ = " + doc.get( PostIndexer.F_ZIP ) );
	System.out.println( "X֋ǖ = " + doc.get( PostIndexer.F_POST ) );
    }

    protected void printSummary( final Document doc ){
	System.out.println( "==========================================" );
	System.out.println( " = " + doc.get( PostIndexer.F_NAME ) );
	System.out.println( "Z = " + doc.get( PostIndexer.F_ADDR ) );
	System.out.println( "ʗX֔ԍ = " + doc.get( PostIndexer.F_INDZIP ) );
    }

    protected Directory getDirectory() throws SearcherException {
	try{
	    if( directory == null )
		directory = FSDirectory.getDirectory( indexDir, false );
	}
	catch( IOException e ){
	    throw new SearcherException( e );
	}
	return directory;
    }
}
