package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public abstract class AbstractPostSortSearcher extends AbstractPostSearcher {

    protected AbstractPostSortSearcher( String indexDir ){
	super( indexDir );
    }

    protected void searchIndex( final Query query, final Sort sort ) throws SearcherException {

	System.out.println( "Query = \"" + query.toString() +
			    "\", Sort = \"" + sort.toString() + "\"" );
	IndexSearcher searcher = null;
	try{
	    searcher = new IndexSearcher( getDirectory() );
	    Hits hits = searcher.search( query, sort );
	    printHits( searcher, query, hits );
	}
	catch( IOException e ){
	    throw new SearcherException( e );
	}
	finally{
	    try{
		if( searcher != null )
		    searcher.close();
	    }
	    catch( IOException ignore ){}
	}
    }
}
