package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.BookIndexer;

public class TestBooleanQuery extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestBooleanQuery tbq = new TestBooleanQuery( args[0] );
	tbq.execute();
    }

    private TestBooleanQuery( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	Query title = new TermQuery( new Term( BookIndexer.F_TITLE, "java" ) );
	Query summary = new TermQuery( new Term( BookIndexer.F_SUMMARY, "J" ) );
	BooleanQuery query = new BooleanQuery();
	query.add( title, BooleanClause.Occur.MUST );
	query.add( summary, BooleanClause.Occur.MUST );
	searchIndex( query );
    }
}
