package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.BookIndexer;

public class TestBooleanQueryMinNum extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestBooleanQueryMinNum tbqmn = new TestBooleanQueryMinNum( args[0] );
	tbqmn.execute();
    }

    private TestBooleanQueryMinNum( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	Query title = new TermQuery( new Term( BookIndexer.F_TITLE, "java" ) );
	Query summary1 = new TermQuery( new Term( BookIndexer.F_SUMMARY, "J" ) );
	Query summary2 = new TermQuery( new Term( BookIndexer.F_SUMMARY, "vO" ) );
	Query summary3 = new TermQuery( new Term( BookIndexer.F_SUMMARY, "IuWFNg" ) );
	Query summary4 = new TermQuery( new Term( BookIndexer.F_SUMMARY, "vWFNg" ) );
	BooleanQuery query = new BooleanQuery();
	query.add( title, BooleanClause.Occur.SHOULD );
	query.add( summary1, BooleanClause.Occur.SHOULD );
	query.add( summary2, BooleanClause.Occur.SHOULD );
	query.add( summary3, BooleanClause.Occur.SHOULD );
	query.add( summary4, BooleanClause.Occur.SHOULD );
	query.setMinimumNumberShouldMatch( 2 );
	searchIndex( query );
    }
}
