package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import gihyo.lucene.ch3.BookIndexer;

public class TestConstantScoreRangeQuery extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestConstantScoreRangeQuery tcsrq = new TestConstantScoreRangeQuery( args[0] );
	tcsrq.execute();
    }

    private TestConstantScoreRangeQuery( String indexDir ){
	super( indexDir );
    }

    protected void printDocument( final Document doc ){
	System.out.println( "==========================================" );
	System.out.println( "^Cg = " + doc.get( BookIndexer.F_TITLE ) );
	System.out.println( "s = " + doc.get( BookIndexer.F_DATE ) );
    }

    protected void printSummary( final Document doc ){
	System.out.println( "==========================================" );
	System.out.println( "^Cg = " + doc.get( BookIndexer.F_TITLE ) );
	System.out.println( "s = " + doc.get( BookIndexer.F_DATE ) );
    }

    private void execute() throws SearcherException {
	Query query = new ConstantScoreRangeQuery( BookIndexer.F_DATE, "20050701", "20050831", true, true );
	searchIndex( query );

	Query q1 = new ConstantScoreRangeQuery( BookIndexer.F_DATE, "20050701", "20050731", true, true );
	q1.setBoost( 0.5F );
	Query q2 = new ConstantScoreRangeQuery( BookIndexer.F_DATE, "20050801", "20050831", true, true );
	q2.setBoost( 2.0F );
	BooleanQuery bq1 = new BooleanQuery();
	bq1.add( q1, BooleanClause.Occur.SHOULD );
	bq1.add( q2, BooleanClause.Occur.SHOULD );
	searchIndex( bq1 );

	q1.setBoost( 2.0F );
	q2.setBoost( 0.5F );
	BooleanQuery bq2 = new BooleanQuery();
	bq2.add( q1, BooleanClause.Occur.SHOULD );
	bq2.add( q2, BooleanClause.Occur.SHOULD );
	searchIndex( bq2 );
    }
}
