package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Hits;
import gihyo.lucene.ch3.PostIndexer;

public class TestFixTooManyClauses extends AbstractPostSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestFixTooManyClauses ttmc = new TestFixTooManyClauses( args[0] );
	ttmc.execute();
    }

    private TestFixTooManyClauses( String indexDir ){
	super( indexDir );
    }

    protected void printHits( final IndexSearcher searcher, final Query query, final Hits hits ){
	int length = hits.length();
	System.out.println( Integer.toString( length ) + " qbg܂B" );
    }

    private void execute() throws SearcherException {
	Query query = new ConstantScoreRangeQuery( PostIndexer.F_INDZIP, "1000000", "1999999", true, true );
	searchIndex( query );
    }
}
