package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.PostIndexer;

public class TestFuzzyQuery extends AbstractPostSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestFuzzyQuery tfq = new TestFuzzyQuery( args[0] );
	tfq.execute();
    }

    private TestFuzzyQuery( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	Query query = new FuzzyQuery( new Term( PostIndexer.F_NAME, "d" ) );
	searchIndex( query );
	query = new FuzzyQuery( new Term( PostIndexer.F_NAME, "d" ), 0.3F );
	searchIndex( query );
    }
}
