package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import gihyo.lucene.ch3.PostIndexer;

public class TestFuzzyQueryRewrite extends AbstractPostSearcher {

    public static void main( String args[] ) throws IOException, SearcherException {
	TestFuzzyQueryRewrite tfqr = new TestFuzzyQueryRewrite( args[0] );
	tfqr.execute();
    }

    private TestFuzzyQueryRewrite( String indexDir ){
	super( indexDir );
    }

    private void execute() throws IOException, SearcherException {
	Query query = new FuzzyQuery( new Term( PostIndexer.F_NAME, "d" ) );
	System.out.println( "query = " + query.toString() );
	Directory directory = getDirectory();
	IndexReader reader = IndexReader.open( directory );
	Query rewrited = query.rewrite( reader );
	System.out.println( "rewrited = " + rewrited.toString() );
	reader.close();
	directory.close();
    }
}
