package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;
import gihyo.lucene.ch3.BookIndexer;

public class TestMultiFieldQueryParser extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestMultiFieldQueryParser tmfqp = new TestMultiFieldQueryParser( args[0] );
	tmfqp.execute();
    }

    private TestMultiFieldQueryParser( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	String[] queries = { "vO~O", "", "" };
	String[] fields = { BookIndexer.F_TITLE, BookIndexer.F_AUTHOR, BookIndexer.F_SUMMARY };
	BooleanClause.Occur[] occurs = new BooleanClause.Occur[] { BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD };
	try{
	    Query query = MultiFieldQueryParser.parse( queries, fields, occurs, getAnalyzer() );
	    searchIndex( query );
	    query = MultiFieldQueryParser.parse( "vO~O", fields, occurs, getAnalyzer() );
	    searchIndex( query );
	    QueryParser qp = new MultiFieldQueryParser( fields, getAnalyzer() );
	    query = qp.parse( "f[^x[X" );
	    searchIndex( query );
	}
	catch( ParseException e ){
	    throw new SearcherException( e );
	}
    }
}
