package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.BookIndexer;

public class TestMultiPhraseQuery extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestMultiPhraseQuery tpq = new TestMultiPhraseQuery( args[0] );
	tpq.execute();
    }

    private TestMultiPhraseQuery( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	// PhraseQuery + BooleanQuery
	PhraseQuery pq1 = new PhraseQuery();
	pq1.add( new Term( BookIndexer.F_SUMMARY, "" ) );
	pq1.add( new Term( BookIndexer.F_SUMMARY, "" ) );
	PhraseQuery pq2 = new PhraseQuery();
	pq2.add( new Term( BookIndexer.F_SUMMARY, "" ) );
	pq2.add( new Term( BookIndexer.F_SUMMARY, "i" ) );
	BooleanQuery bq = new BooleanQuery();
	bq.add( pq1, BooleanClause.Occur.SHOULD );
	bq.add( pq2, BooleanClause.Occur.SHOULD );
	searchIndex( bq );
	// MultiPhraseQuery
	MultiPhraseQuery query = new MultiPhraseQuery();
	query.add( new Term( BookIndexer.F_SUMMARY, "" ) );
	query.add( new Term[] {
	    new Term( BookIndexer.F_SUMMARY, "" ),
	    new Term( BookIndexer.F_SUMMARY, "i" ) } );
	searchIndex( query );
    }
}
