package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.document.Document;
import gihyo.lucene.ch3.PostIndexer;

public class TestPostKyoto extends AbstractPostSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestPostKyoto tpp = new TestPostKyoto( args[0] );
	tpp.execute();
    }

    private TestPostKyoto( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	QueryParser qp = new QueryParser( PostIndexer.F_ADDR, getAnalyzer() );
	try{
	    Query query = qp.parse( "s" );
	    searchIndex( query );
	}
	catch( ParseException e ){
	    throw new SearcherException( e );
	}
    }

    protected void printDocument( final Document doc ){
	// ʕ\}~
    }

    protected void printSummary( final Document doc ){
	// ʕ\}~
    }
}
