package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryFilter;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.PostIndexer;

public class TestQueryFilter extends AbstractPostFilterSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestQueryFilter tqf = new TestQueryFilter( args[0] );
	tqf.execute();
    }

    private TestQueryFilter( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	Query query = new TermQuery( new Term( PostIndexer.F_NAME, "s" ) );
	searchIndex( query, getHokkaidoFilter() );
	searchIndex( query, getAomoriFilter() );
    }

    private Filter getHokkaidoFilter(){
	Query query = new RangeQuery( new Term( PostIndexer.F_CODE, "01000" ),
				      new Term( PostIndexer.F_CODE, "01999" ), true );
	return new QueryFilter( query );
    }

    private Filter getAomoriFilter(){
	Query query = new RangeQuery( new Term( PostIndexer.F_CODE, "02000" ),
				      new Term( PostIndexer.F_CODE, "02999" ), true );
	return new QueryFilter( query );
    }
}
