package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.BookIndexer;

public class TestQuerySetBoost extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestQuerySetBoost tqsb = new TestQuerySetBoost( args[0] );
	tqsb.execute();
    }

    private TestQuerySetBoost( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	Query q1 = new TermQuery( new Term( BookIndexer.F_SUMMARY, "linux" ) );
	Query q2 = new TermQuery( new Term( BookIndexer.F_SUMMARY, "freebsd" ) );
	q1.setBoost( 2.0F );
	q2.setBoost( 0.5F );
	BooleanQuery bq1 = new BooleanQuery();
	bq1.add( q1, BooleanClause.Occur.SHOULD );
	bq1.add( q2, BooleanClause.Occur.SHOULD );
	searchIndex( bq1 );
	q1.setBoost( 0.5F );
	q2.setBoost( 2.0F );
	BooleanQuery bq2 = new BooleanQuery();
	bq2.add( q1, BooleanClause.Occur.SHOULD );
	bq2.add( q2, BooleanClause.Occur.SHOULD );
	searchIndex( bq2 );
    }
}
