package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.document.NumberTools;
import gihyo.lucene.ch3.BookIndexer;

public class TestRangeQuery extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestRangeQuery trq = new TestRangeQuery( args[0] );
	trq.execute();
    }

    private TestRangeQuery( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	Term start = new Term( BookIndexer.F_DATE, "20050101" );
	Term end = new Term( BookIndexer.F_DATE, "20051231" );
	Query query = new RangeQuery( start, end, true );
	searchIndex( query );
	start = new Term( BookIndexer.F_PRICE, NumberTools.longToString( 1000 ) );
	end = new Term( BookIndexer.F_PRICE, NumberTools.longToString( 1500 ) );
	query = new RangeQuery( start, end, true );
	searchIndex( query );
    }
}
