package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import gihyo.lucene.ch3.BookIndexer;

public class TestRangeQueryRewrite extends AbstractBookSearcher {

    public static void main( String args[] ) throws IOException, SearcherException {
	TestRangeQueryRewrite trqr = new TestRangeQueryRewrite( args[0] );
	trqr.execute();
    }

    private TestRangeQueryRewrite( String indexDir ){
	super( indexDir );
    }

    private void execute() throws IOException, SearcherException {
	Query query = new RangeQuery( new Term( BookIndexer.F_DATE, "20050701" ),  new Term( BookIndexer.F_DATE, "20050831" ), true );
	System.out.println( "query = " + query.toString() );
	Directory directory = getDirectory();
	IndexReader reader = IndexReader.open( directory );
	Query rewrited = query.rewrite( reader );
	System.out.println( "rewrited = " + rewrited.toString() );
	reader.close();
	directory.close();
    }
}
