package gihyo.lucene.ch4;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.index.Term;
import gihyo.lucene.ch3.BookIndexer;

public class TestTermQuery extends AbstractBookSearcher {

    public static void main( String args[] ) throws SearcherException {
	TestTermQuery ttq = new TestTermQuery( args[0] );
	ttq.execute();
    }

    private TestTermQuery( String indexDir ){
	super( indexDir );
    }

    private void execute() throws SearcherException {
	// JapaneseAnalyzereXgp
	Query query = new TermQuery( new Term( BookIndexer.F_TITLE, "" ) );
	searchIndex( query );
	query = new TermQuery( new Term( BookIndexer.F_TITLE, "񏈗" ) );
	searchIndex( query );
	query = new TermQuery( new Term( BookIndexer.F_ISBN, "4-7741-1231-3" ) );
	searchIndex( query );
	// CJKAnalyzereXgp
	//Query query = new TermQuery( new Term( BookIndexer.F_TITLE, "" ) );
	//searchIndex( query );
	//query = new TermQuery( new Term( BookIndexer.F_TITLE, "񏈗" ) );
	//searchIndex( query );
	//query = new TermQuery( new Term( BookIndexer.F_ISBN, "4-7741-1231-3" ) );
	//searchIndex( query );
    }
}
