package gihyo.lucene.ch6;

/**
 * Copyright 2006 SEKIGUCHI, Koji
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.StringReader;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Highlighter;

public class TestHighlighter {

    static final String TEXT = "}Ő𒆐SƂuł̃vvBŐ̎哱ނ炪\}́A傫h炮Ƃ͂ȂBgKoϊŐcAuO`Wېł͊Ƃ̍ۋ͂߂鈫łv쒆Luƒĉ́w撣͗ƂxƋĂv{lȂǏȊO̊Ŗ@lƐłۂO`WېŁBԎ@l̐ŕSɒƂēɒRoϊEƁAiCɍEȂ肵ƂĊ҂n̂̈ӌ󂯂āAsIȑΗNBAŒƂΏۂ珜OËĂ܂Ƃ߂ƁAΗ͂ƎɌBȂłR呥ōږ̐ł̐mwiɁA҂̒N̖𓾂ƂŎŒ͗͂𓾂ĂB́uĂQŊv̗QtƂBẢAŏdvȐ_c͂܂uɂꂽBƂΔzғʍT̔p~AŒ̃CtX^Cւ̐ł̉e𔖂߂Ƃϓ_c_`Ղ͂ȂB@lŗ̈ɂẮA͂Ȃ疳Ă܂BЂƂAYĂȂȂ̂́ANA}Ȃǂœ{oςx@O܂ł̂ɁAŒȂuł߂͔̂NvƌēƂȂƂBŁE̘_炷΁AΓEŐ͗\ZҐƈ̂Ői߂KvBAł͐iƂĐŐ@IɎgƂłȂBc_AoϕϓɂłȂł̃vB̐Őv肠̂ɂɂ́AނɂŐ̓ƐɏI~łAoϑŜɖڔzłŐÂ̎dg݂KvBāA哱̂́A͂菬򏃈Y񑊂c𖱂߂oϐSʂ̎iߓAoύcœK낤BtAŐv_cX^[gƂɂ́Acc_ǖʂBꂪ̂́A񑊂Őv_c𐭕{ŐƂ2Ă̔nԂő点ƂɈB񑊂̋͂Ȍ㉟Ȃł́AX^bt̎蔖Ȏc͉v̎哱ȂB_c̕䂪ŒɈڂ11ȍ~́ANxŐƂȂׂȂ邾ƂȂBubVđ哝̂͌iC̐ss܂Ƃ݂AKdIj[OXRĐ̌oσ`[ւAő3000hƂǉł̌ɏoB񑊂oύĐւ̋ӎuȂAxc哱̑̐ׂBɁANɂ炸Ő_ɌuʔNRcvm邱ƂdvBxG勳͑Nxɂ܂\ZҐA̘gŌiCϓɏ_ɑΉdg݂ÂĂĂB\Zx̌Đi߂΁AŐ̋@͈iƍ܂Bu\v̒ƂĐŐvɎgށB^u[͂ȂvB񑊂͍N̔NL҉ł錾BŐ̒g͂AŐÂ̎dg݂ł^u[͂ׂłȂB@ułvޔǂ͒JAOcFANAcꐬAĎRYA\ɁAR΍sA؍WATANOANvAiqAX쒼ō\B";
    static final String QUERY = "zғʍT p~";
    static final String FIELD = "F";
    static final String HTML_FILE = "highlighter.html";
    static final String CHARSET = "Shift_JIS";
    static final Analyzer analyzer = new JapaneseAnalyzer();

    public static void main( String[] args ) throws IOException, ParseException {
	QueryParser qp = new QueryParser( FIELD, analyzer );
	Query query = qp.parse( QUERY );
	Scorer scorer = new QueryScorer( query, FIELD );
	Highlighter highlighter = new Highlighter( scorer );
	String body = highlighter.getBestFragment( analyzer, FIELD, TEXT );
	writeHtml( body );
    }

    static void writeHtml( final String body ) throws IOException {
	BufferedWriter bw = new BufferedWriter( new OutputStreamWriter( new FileOutputStream( HTML_FILE ), CHARSET ) );
	bw.write( "<HTML>" );
	bw.write( "<HEAD>" );
	bw.write( "<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + CHARSET + "\">" );
	bw.write( "<TITLE>Apache Lucene Highlighter̃f</TITLE>" );
	bw.write( "</HEAD>" );
	bw.write( "<BODY>" );
	bw.write( body );
	bw.write( "</BODY>" );
	bw.write( "</HTML>" );
	bw.close();
    }
}
